////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBFileOpenDialog.h
//		Definition of the parent class that allows an Open Dialog through the respective platform's Dialog or Panel.
//
//  Copyright © 2011-2012 Acclivity Group LLC. All rights reserved.
//
//  Change History (most recent first):
//
//  05/19/11  G.R.W.  Rewrite to include setters/getters
//  05/06/11  G.R.W.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"
#include "ObsoleteBridge/OBFileDialog.h"

namespace ObsoleteBridge
{
	class EXTERNAL_API OBFileOpenDialog  : public ObsoleteBridge::OBFileDialog
	{
	public:
		static OBFileOpenDialog* Create(void);
		
		static CPString SelectItem(void);
		static CPString SelectItemWithMessage(const CPString& Message);
		static CPString SelectItemWithMessageAndDirectoryPath(const CPString& Message, const CPString& DirectoryPath);
		static CPString SelectItemWithMessageAllowingFileType(const CPString& Message, const CPString& AllowedFileType);
		static CPString SelectItemWithMessageAllowingFileTypes(const CPString& Message, const CPArray& AllowedFileTypes);
		static CPString SelectItemWithMessageAndDirectoryPathAllowingFileType(const CPString& Message, const CPString& DirectoryPath,
																			  const CPString& AllowedFileType);
		static CPString SelectItemWithMessageAndDirectoryPathAllowingFileTypes(const CPString& Message, const CPString& DirectoryPath,
																			   const CPArray& AllowedFileTypes);

		virtual ~OBFileOpenDialog(void);

		virtual void SetAllowMultipleSelection(bool ShouldAllowMultipleSelection) = 0;

		virtual CPString ShowOpenFileDialog(void) = 0;
		virtual CPArray ShowOpenFilesDialog(void) = 0;

	protected:
		OBFileOpenDialog(void);
	};
}
